﻿using Percent___Qualification_work.Classes;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;
using System.Linq;
using System.Windows.Forms;
using System.Windows.Forms.Design;
using System.Threading.Tasks;

namespace Percent___Qualification_work.userControls
{
    public partial class addGame : UserControl
    {
        public List<DataRow> gameData;
        Game existingGame;
        Game newGame;
        api_scrape scrape = new api_scrape();
        byte[] imageBlob;
        public addGame()
        {
            InitializeComponent();
            gameGenre.DropDownStyle = ComboBoxStyle.DropDownList;
        }

        private async void findGameBtn_Click(object sender, EventArgs e)
        {
            string name = gameName.Text;
            existingGame = DatabaseConnection.Instance.GetGame(name);
            if (existingGame != null)
            {
                DialogResult result = MessageBox.Show(existingGame.ToString(), "Confirm game", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (result == DialogResult.Yes)
                {
                    if (DatabaseConnection.Instance.IsGameInList(Authentication.ActiveUserID, existingGame.Id) == false)
                    {
                        allInputs.Visible = true;
                        gameName.Enabled = false;
                        gameDeveloper.Text = existingGame.Developer;
                        gameDeveloper.Enabled = false;
                        gameGenre.Text = existingGame.Genre;
                        gameGenre.Enabled = false;
                        gameYear.Value = existingGame.ReleaseYear;
                        gameYear.Enabled = false;
                    }
                    else MessageBox.Show("This game is already in your list!");
                }
            }
            else
            {
                MessageBox.Show("Looks like this game isnt in our database. The system will try to export data from intenet. Please wait...");
                await GetGameFromAPI(gameName.Text);
                if (newGame != null)
                {
                    allInputs.Visible = true;
                    gameName.Enabled = false;
                    gameDeveloper.Text = newGame.Developer;
                    gameDeveloper.Enabled = false;
                    gameGenre.Text = newGame.Genre;
                    gameGenre.Enabled = false;
                    gameYear.Value = newGame.ReleaseYear;
                    gameYear.Enabled = false;

                    MessageBox.Show(newGame.CoverImage.ToString());

                }
                else
                {
                    allInputs.Visible = true;
                    openFile.Visible = true;
                    imageName.Visible = true;
                    
                    
                }
            }      
        }

        private async Task GetGameFromAPI(string gameName)
        {
            newGame = await scrape.GetGame(gameName);
            
        }

        private void addGame_Load(object sender, EventArgs e)
        {

        }

        private void openFile_Click(object sender, EventArgs e)
        {

            DialogResult result = coverImageDialog.ShowDialog();

        }

        private void coverImageDialog_FileOk(object sender, CancelEventArgs e)
        {
            string fileName = coverImageDialog.FileName;
            string fileExtension = Path.GetExtension(fileName).ToLower();

            // Check if the file is a PNG or JPG/JPEG
            if (fileExtension == ".png" || fileExtension == ".jpg" || fileExtension == ".jpeg")
            {
                // Convert the image file to a byte array 
                imageBlob = File.ReadAllBytes(fileName);




                // Display only the file name without the path
                string fileOnlyName = Path.GetFileName(fileName);
                imageName.Text = fileOnlyName;
            }
            else
            {
                MessageBox.Show("Please select a valid image file (.png, .jpg, .jpeg).", "Invalid File Type", MessageBoxButtons.OK, MessageBoxIcon.Error);
                e.Cancel = true; // Cancel the file selection if the file is not valid
            }
        }

        private void saveGame_Click(object sender, EventArgs e)
        {

            {

            }
            if (existingGame != null)
            {
                int score = Convert.ToInt32(userScore.Value);
                DatabaseConnection.Instance.AddToUserList(Authentication.ActiveUserID, existingGame.Id,score);
            }
            else
            {
                if (gameName.Text != "" && gameGenre.Text != "" && gameDeveloper.Text != "" && gameYear.Value != null && imageBlob != null)
                {
                    newGame = new Game(null, gameName.Text, gameGenre.Text, gameDeveloper.Text, Convert.ToInt32(gameYear.Value), imageBlob);
                    DatabaseConnection.Instance.addGameToDB(newGame);
                    DatabaseConnection.Instance.AddToUserList(Authentication.ActiveUserID, newGame.Id, Convert.ToInt32(userScore.Value));

                }
                else if(newGame != null)
                {
                    DatabaseConnection.Instance.addGameToDB(newGame);
                    DatabaseConnection.Instance.AddToUserList(Authentication.ActiveUserID, newGame.Id, Convert.ToInt32(userScore.Value));
                }
                else MessageBox.Show("Please fill in all the fields! And don't forget to add a cover image!");
            }

        }

        private void backBtn_Click(object sender, EventArgs e)
        {
            
        }
    }
}
